<?php

class ITSEC_Settings_Page_Sidebar_Widget_Malware_Scan extends ITSEC_Settings_Page_Sidebar_Widget {
	private $script_version = 2;


	public function __construct() {
		$this->id = 'malware-scan';
		$this->title = __( 'Malware Scan', 'it-l10n-ithemes-security-pro' );
		$this->priority = 8;

		parent::__construct();
	}

	public function enqueue_scripts_and_styles() {
		$vars = array(
			'clickedButtonText' => __( 'Scanning...', 'it-l10n-ithemes-security-pro' ),
			'showDetailsText'   => __( 'Show Details', 'it-l10n-ithemes-security-pro' ),
			'hideDetailsText'   => __( 'Hide Details', 'it-l10n-ithemes-security-pro' ),
		);

		wp_enqueue_script( 'itsec-settings-malware-scan-settings-script', plugins_url( 'js/settings-page.js', __FILE__ ), array( 'jquery' ), $this->script_version, true );
		wp_localize_script( 'itsec-settings-malware-scan-settings-script', 'itsecMalwareScanData', $vars );

		wp_enqueue_style( 'itsec-settings-malware-scan-style', plugins_url( 'css/settings.css', __FILE__ ), array(), $this->script_version );
	}

	public function handle_ajax_request( $data ) {
		require_once( dirname( __FILE__ ) . '/class-itsec-malware-scanner.php' );
		require_once( dirname( __FILE__ ) . '/class-itsec-malware-scan-results-template.php' );

		$temporary_error = false;

		if ( ! ITSEC_Core::current_user_can_manage() ) {
			$results = new WP_Error( 'itsec-settings-malware-scan-insufficient-privileges', __( 'An error prevented the scan from completing as expected. The currently logged in user does not have sufficient permissions to run this scan. You may need to log out of the site and log back in.', 'it-l10n-ithemes-security-pro' ) );
		} else {
			$results         = ITSEC_Malware_Scanner::scan();
			$temporary_error = ITSEC_Malware_Scanner::is_sucuri_error( $results );
		}

		if ( $temporary_error ) {
			ITSEC_Response::add_warning( __( 'Malware scanning is temporarily unavailable, please try again later.', 'it-l10n-ithemes-security-pro' ) );
		} else {
			ITSEC_Response::set_response( ITSEC_Malware_Scan_Results_Template::get_html( $results, true ) );
		}
	}

	public function render( $form ) {

?>
	<div class="hide-if-no-js">
		<p><?php printf( __( 'This malware scan is powered by <a href="%s">Sucuri SiteCheck</a>. It checks for known malware, blacklisting status, website errors and out-of-date software. Although the Sucuri team does its best to provide thorough results, 100%% accuracy is not realistic and is not guaranteed.', 'it-l10n-ithemes-security-pro' ), esc_url( 'https://ithemes.com/sitecheck' ) ); ?></p>
		<p><?php printf( __( 'Results of previous malware scans can be found on the <a href="%s">logs page</a>.', 'it-l10n-ithemes-security-pro' ), ITSEC_Core::get_logs_page_url('malware' ) ); ?></p>
		<div class='itsec-malware-scan-results-wrapper'></div>
		<?php $form->add_button( 'start', array( 'value' => __( 'Scan Homepage for Malware', 'it-l10n-ithemes-security-pro' ), 'class' => 'button-primary' ) ); ?>
	</div>
	<div class="hide-if-js">
		<p><?php _e( 'The malware scanner requires Javascript in order to function. If Javascript is disabled in your browser, please enable it. If Javascript is not disabled, a script from another plugin, the theme, or a broken WordPress file is preventing the malware scanner\'s script from executing properly. Please try disabling other plugins to see if that resolves the issue.', 'it-l10n-ithemes-security-pro' ); ?></p>
	</div>
<?php
	}

	protected function save( $data ) {
	}
}
new ITSEC_Settings_Page_Sidebar_Widget_Malware_Scan();
