/**
 * External dependencies
 */
import { has, get } from 'lodash';

/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import WrappedSection from './wrapped-section';

function BlacklistDetails( { results } ) {
	const status = has( results, [ 'BLACKLIST', 'WARN' ] ) ? 'warn' : 'clean';

	return (
		<WrappedSection type="malware" status={ status } description={ __( 'Blacklist', 'ithemes-security-pro' ) }>
			<ul>
				{ get( results, [ 'BLACKLIST', 'WARN' ], [] ).map( ( entry, i ) => (
					<li className="itsec-malware-scan-warn" key={ i }>
						<span>
							<a href={ entry[ 1 ] }>{ entry[ 0 ] }</a>
						</span>
					</li>
				) ) }
				{ get( results, [ 'BLACKLIST', 'INFO' ], [] ).map( ( entry, i ) => (
					<li className="itsec-malware-scan-clean" key={ i }>
						<span>
							<a href={ entry[ 1 ] }>{ entry[ 0 ] }</a>
						</span>
					</li>
				) ) }
			</ul>
		</WrappedSection>
	);
}

export default BlacklistDetails;
