/**
 * External dependencies
 */
import classnames from 'classnames';
import { isEmpty } from 'lodash';

/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { Fragment } from '@wordpress/element';
import { Button } from '@wordpress/components';
import { compose, withState, withInstanceId } from '@wordpress/compose';

function WrappedSection( { type, status, description, isShowing, setState, instanceId, children } ) {
	let statusText;

	switch ( status ) {
		case 'clean':
			statusText = __( 'Clean', 'ithemes-security-pro' );
			break;
		case 'warn':
			statusText = __( 'Warn', 'ithemes-security-pro' );
			break;
		case 'error':
			statusText = __( 'Error', 'ithemes-security-pro' );
			break;
		default:
			statusText = status;
			break;
	}

	const statusEl = ( <span className={ `itsec-malware-scan-${ status }` }>{ statusText }</span> );

	return (
		<div className={ classnames( 'itsec-malware-scan-results-section', `itsec-malware-scan-results-${ type }-section` ) }>
			{ isEmpty( children ) ? ( <p>{ statusEl } { description }</p> ) : (
				<Fragment>
					<p>
						{ statusEl }
						{ description }
						<Button isLink className="itsec-malware-scan-toggle-details" onClick={ () => setState( { isShowing: ! isShowing } ) }
							aria-expanded={ isShowing } aria-controls={ `itsec-malware-scan-details--${ instanceId }` }>
							{ isShowing ?
								__( 'Hide Details', 'ithemes-security-pro' ) :
								__( 'Show Details', 'ithemes-security-pro' )
							}
						</Button>
					</p>
					<div className="itsec-malware-scan-details" id={ `itsec-malware-scan-details--${ instanceId }` } style={ { display: isShowing ? 'block' : 'none' } }>
						{ children }
					</div>
				</Fragment>
			) }
		</div>
	);
}

export default compose( [
	withState( { isShowing: false } ),
	withInstanceId,
] )( WrappedSection );
